# 奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式
本文转载自： [奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://www.qbitai.com/2025/07/307570.html)

POLAR：与绝对偏好解耦的策略判别学习

> 允中 发自 凹非寺
>
> 量子位 | 公众号 QbitAI

强化学习改变了大语言模型的后训练范式，可以说，已成为AI迈向AGI进程中的关键技术节点。

然而，其中**奖励模型**的设计与训练，始终是制约后训练效果、模型能力进一步提升的瓶颈所在。

当前，大模型在**Next Token Prediction**和**Test-time Scaling**两种扩展范式下，通过大规模的数据和模型扩展，实现了能力的持续跃升。但相比之下，奖励模型缺乏系统性的预训练和扩展方法，导致其能力难以随计算量增长而持续提升，成为阻碍强化学习链路进一步扩展的短板。

如何解决？

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/nWVwhFqFR8G5aNY7.webp)

现在，来自上海人工智能实验室的研究团队提出了一种新的思路：

他们找到了一种与绝对偏好解耦的、可以真正高效扩展的奖励建模新范式——**策略判别学习**（Policy Discriminative Learning， POLAR），使奖励模型能够像大语言模型一样，具备可扩展性和强泛化能力。

POLAR为大模型后训练带来突破性进展，并有望打通RL链路扩展的最后一环。

先来看一下POLAR能做到什么。

与传统的奖励模型不同，POLAR是根据参考答案为模型的输出打分。这意味着POLAR可以灵活地基于不同场景的参考答案给出不同的奖励分数，轻松适配多样的定制化需求。

下面是一个开放问题的例子，对应有三个不同风格的回复：

**问题：**彩虹是怎么形成的？

**回答一：**彩虹是阳光经过水滴折射和反射后形成的。

**回答二：**当阳光照射到空气中的小水滴时，光线会进入水滴发生折射，再从水滴的内壁反射后再次折射出水滴。由于不同波长的光折射角度不同，最终呈现出不同的颜色，这些颜色组合起来就形成了我们所看到的彩虹。

**回答三：**彩虹是阳光通过空气中的水滴折射和反射后形成的。生活中我们经常在雨后或喷泉、水幕附近看到彩虹，有时候还会看到双彩虹甚至三重彩虹呢！不过很可惜，彩虹本身只是光学现象，没法真正走近摸到。

对于这种开放问题，不同的用户可能会偏向不同风格的回复。此时，传统奖励模型的“绝对偏好”无法灵活应对不同的定制化场景。**而POLAR只需要根据不同的参考回复，即可为三种回答给出不同的偏序关系，无需重新训练奖励模型**。

来看POLAR实际打分的例子。如果给定的参考风格是简短扼要，POLAR会给第一个回答最高的分数。

**参考一**：阳光穿过水滴的折射与反射形成了彩虹。

**回答一**：-2.095703125

**回答二**：-5.859375

**回答三**：-7.44921875

如果参考的是详细分析风格，POLAR会给第二个回答最高分。

**参考二**：彩虹是阳光经过空气中的许多小水滴后，通过连续的折射与反射而产生的。当阳光进入水滴时，光线首先被折射进入水滴内部，然后在水滴内壁发生一次反射，随后再次折射射出水滴。因为阳光中不同颜色的光线波长各不相同，折射时产生的角度也略有差别，这使得光线被分解成红、橙、黄、绿、蓝、靛、紫等颜色，从而形成了我们所看到的绚丽彩虹。

**回答一**：-8.5625

**回答二**：-5.2421875

**回答三**：-8.125

如果参考的是俏皮发散风格，此时第三个回答的奖励分数最高。

**参考三**：彩虹是阳光经过水滴折射和反射后形成的。在日常生活中，只要条件合适，比如刚下完雨、喷泉边，甚至在水幕电影附近，都能邂逅这种美丽的景象。不过呢，虽然彩虹看上去很近，但它毕竟只是光的奇妙游戏，我们无论怎么追逐，都无法真正触碰到它，这也是大自然给我们留下的小小遗憾吧～

**回答一**：-9.53125

**回答二**：-8.609375

**回答三**：-4.484375

除了上述处理开放问题的灵活性，POLAR也能解决有标准答案的闭式问题。相比“基于规则的验证”（RLVR）所提供的0/1二元奖励，POLAR可以提供更加细粒度的偏好区分。

下面是一个例子：

**问题**：公交车上原本有10名乘客，到站后下去了3名，上来了5名，现在车上有多少名乘客？

**参考答案**： 10名乘客 – 3名下车 + 5名上车。答案是12。

**回答一（答案正确，思路正确）**：最初有10名乘客，到站后3个人下车，因此剩下7人；又新上来了5人，7人加上5人，总共是12人。因此最终有12名乘客。

**分数**：-5.1953125

**回答二（答案正确，无思路）**：现在车上有12名乘客。

**分数**：-5.6171875

**回答三（答案错误，思路正确）**：10名乘客 – 3名下车 + 5名上车。答案是13。

**分数**： -8.953125

**回答四（答案正确，思路错误）**：10名乘客 + 3名下车 – 5名上车。答案是12。

**分数**： -9.5859375

**回答五（答案错误，无思路）**：现在车上有13名乘客。

**分数**：-11.0703125

**回答六（答案错误，思路错误）**：10名乘客 + 3名下车 – 5名上车。答案是13。

**分数**：-12.125

由此可见，POLAR不仅摆脱了传统奖励模型“绝对偏好”的限制，更加弥补了RLVR难以拓展场景、奖励信号稀疏等问题。

POLAR基于参考答案对模型输出进行打分，对更加接近参考答案的输出赋予更高的奖励值，在强化学习过程中让训练策略逐步向最优策略偏移。

这种特性使得POLAR**完美契合强化微调框架**（Reinforcement Fine-tuning，RFT），让RFT在通用场景的应用成为可能。

在探讨POLAR的训练方式之前，我们首先回顾一下大语言模型（LLM）的成功之路。

传统的机器学习是为特定的任务训练特定的模型，例如为翻译任务训练翻译模型，很难做到任务间的泛化。

LLM的成功就在于用Next Token Prediction的形式统一了所有任务，解决了任务形式不同导致无法泛化的难题。

现在奖励模型（RM）的设计仍然在重蹈传统方案的老路，即为特定场景标注偏好数据，训特定场景的RM。

其中，RM的打分标准是基于人类偏好来设定的，而打分标准就如同LLM的任务形式，具有多样性且无法穷举。

那么，能不能仿照LLM的成功之路，重新设计RM的训练范式，就像消除LLM的“任务形式”一样，找到一个**脱离于“打分标准”之外的更本质的优化目标函数来进行预训练**呢？

正是基于这样的思路，上海AI Lab提出了预训练奖励模型**POLAR**。

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/F8ssbqxQ0f30MJyN.png)

△POLAR的两阶段训练（预训练和偏好微调）以及在RFT中的使用方法

与传统的基于“绝对偏好”的奖励建模方式不同，POLAR 通过衡量训练策略与目标策略之间的“**距离**”来作为奖励信号。当训练策略越接近目标策略时，POLAR 就给予越高的奖励。

具体来说，POLAR 使用了一种**对比学习**（Contrastive Learning）的方式学会策略分布的距离度量：**同一个策略模型采样的结果作为正例，不同策略模型采样的结果作为负例**。

通过这种方式构造正负样本，虽然有一些反直觉，但它是一种真正无偏的信号，和对抗生成网络（GAN）中判断是否是真实样本类似。

由于“距离”是一种相对性的概念，因此目标策略可任意指定，从而摆脱了对偏好数据人工标注的依赖，具有极强的可扩展潜力。实际上，POLAR的预训练语料完全**通过自动化合成数据构建**。

具体而言，研究人员从LLM预训练语料中采样出大量的文本前缀，并从策略模型池（由开源的**131**个Base LLM和**53**个Chat LLM组成）中随机取模型进行轨迹采样。预训练目标使用Bradley-Terry Loss：

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/D4PUs646vCkxTrK9.png)

其中，A1和A2代表相同策略模型生成的轨迹（正样本对）；B1代表不同策略模型生成的轨迹（负样本）。

由于“距离”具有相对性，这里的A和B两个**策略模型可以任意选取**。例如，A1和A2可以由Qwen 1.5B采样得到，B1可以由Qwen 72B采样得到。通过这种方式，POLAR的预训练语料非常容易扩展。

POLAR使RM学会为相近策略产生的轨迹赋予更高奖励，从而隐式建模策略分布的差异和距离。在这一阶段，POLAR-1.8B共使用了**0.94T Token**的预训练数据，POLAR-7B共使用了**3.6T Token**的预训练数据。

在预训练阶段之后，POLAR可以使用少量的偏好数据对齐人类偏好。具体来说，对于同一个Prompt，采样三条轨迹，由人工标注偏好顺序。同样使用Bradley-Terry Loss进行微调：

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/EDkK1X5U4yREOI3P.png)

其中，A > B > C，分别代表偏好最优、次优、最差的轨迹。这种偏好排序隐式定义了一种“策略差异”，例如A可以视为从最佳策略分布中采样得到，而C可以视为从一个与最佳策略相差较远的策略分布中采样得到。

**POLAR具有Scaling效应吗？**

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/ok0fQMrr1hFsmCMw.png)

△POLAR的Scaling Laws

一个重要的问题是，POLAR预训练范式是否真的能展现Scaling效应？

研究人员从模型参数**N**和计算量**C**两个方面进行了实验。

如图所示，POLAR的验证集损失随模型参数N的增加呈幂律关系下降，拟合的R2值为0.9886。

验证集损失也随最优训练计算量C的增加呈幂律关系下降，拟合的R2值为0.9912。

这些结果表明，**分配更多的计算资源将持续带来更好的POLAR性能。也就是说，新范式展现出了与大语言模型Next Token Prediction目标类似的Scaling Laws。**

**这体现了POLAR预训练方法的显著扩展优势，以及用于构建更通用和更强大的奖励模型的巨大潜力。**

研究人员通过一系列实验证明，POLAR能做到对性能和泛化的双重保证。

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/VRrzEKCEO4RjZGTY.webp)

△偏好评估实验结果

在偏好评估方面，POLAR展现出优越的性能和全面性，在大多数任务维度上优于SOTA奖励模型。

例如，在STEM任务中，POLAR-1.8B和POLAR-7B分别超越了最佳基线24.9和26.2个百分点，并且能够准确识别推理、聊天、创意写作等通用任务中轨迹的细微区别，准确预测人类偏好。

值得注意的是，POLAR-1.8B仅有1.8B参数，就可取得与Skywork-Reward-27B和WorldPM-72B-UltraFeedback（参数量分别为其15倍和40倍）相当的结果，凸显了POLAR的强大潜力。

![奖励模型也能Scaling！上海AI Lab突破强化学习短板，提出策略判别学习新范式](https://pic.code-nav.cn/post_picture/1610518142000300034/9bhXtrJWCfOID4lj.webp)

△强化微调实验结果

在强化微调实验中，POLAR持续优于SOTA的开源奖励模型。

例如，使用POLAR-7B微调的Llama-3.1-8B在所有基准测试中，相对于初始结果平均提升了9.0%，相对于WorldPM-72B-UltraFeedback优化的结果提升了6.7%。

POLAR能够从预训练阶段学习策略模型之间的细微区别，而不仅仅依赖于标注的偏好对，从而显著增强了实际RL应用时的奖励信号泛化性。

实验结果表明，尽管POLAR-1.8B和POLAR-7B在偏好评估中表现相似，但在下游RL实验中，POLAR-7B展现出了显著优势。从1.8B到7B的效果提升，进一步说明了POLAR所具有的Scaling效应。

总结来说，POLAR在预训练阶段通过对比学习建模策略间的距离，仅需少量偏好样本就可对齐人类偏好。在使用阶段，POLAR利用RFT范式对LLM进行强化学习，展现出了极佳的泛化性。POLAR作为一种全新的、可扩展的奖励模型预训练方法，为LLM后训练带来了新的可能，让通用RFT多了一种有效实践方案。有望打通RL链路Scaling的最后一环。

论文链接：https://arxiv.org/pdf/2507.05197  
项目链接：https://github.com/InternLM/POLAR  
模型链接：https://huggingface.co/internlm/POLAR-7B

— 完 —

*版权所有，未经授权不得以任何形式转载及使用，违者必究。*